<?php
namespace VM\AdminBundle\Command;

use Doctrine\Bundle\DoctrineBundle\Registry;
use Doctrine\ORM\EntityManager;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Response;
use VM\AdminBundle\Services\ApiGetter;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Entity\CompanyOfferReport;
use VM\ApiBundle\Entity\AccountChange;
use VM\ApiBundle\Entity\CompanyReport;
use VM\ApiBundle\Entity\GroupRoundReportCode;
use VM\ApiBundle\Entity\User;

class CreateTeacherCreatorCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('game:create:teacher:creator')
            ->setDescription('Creates account with role ROLE_TEACHER_CREATOR.')
            ->addOption('name', null, InputOption::VALUE_REQUIRED, 'Teacher creator name')
            ->addOption('surname', null, InputOption::VALUE_REQUIRED, 'Teacher creator surname')
            ->addOption('email', null, InputOption::VALUE_REQUIRED, 'Teacher creator email')
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $EntityManager = $this->getDoctrine();

        $name = $input->getOption('name');
        $surname = $input->getOption('surname');
        $email = $input->getOption('email');

        $SsoCommunication = $this->getContainer()->get('vm_admin.sso.communication');
        $defaultPassword = rand(1000000, 9999999);

        try
        {
            if(!empty($name) && !empty($surname) && !empty($email))
            {
                $response = $SsoCommunication->registerUser($name, $surname, $email, md5($defaultPassword));

                $User = new User();
                $User->setGroup(null);
                $User->setUsername($email);
                $User->setName($name);
                $User->setSurname($surname);
                $User->setEmail($email);
                $User->setExternalId($response['user_id']);
                $User->setRoles(array('ROLE_TEACHER_CREATOR'));

                $EntityManager->persist($User);

                $SsoCommunication->registrationConfirm($User->getExternalId(), $response['confirmation_token']);
                $loginData = $SsoCommunication->loginUser($User->getEmail(), md5($defaultPassword));
                $SsoCommunication->userSetRoles($response['user_id'], $loginData['token'], array('ROLE_TEACHER_CREATOR'));
                $getRolesResponse = $SsoCommunication->userGetRoles($response['user_id'], $loginData['token']);
                if(count($getRolesResponse['roles']) < 1)
                {
                    throw new \Exception('Role not set. Probably role does not exist in SSO.');
                }
                $SsoCommunication->logoutUser($response['user_id'], $loginData['token']);
                $EntityManager->flush();
            }
            else
            {
                throw new \Exception('Missing some data to create account.');
            }
        }
        catch(\Exception $exception)
        {
            $output->writeln('Error: '.$exception->getMessage());
            return false;
        }

        $output->writeln("Created user ROLE_TEACHER_CREATOR - ".$name." ".$surname." ".$email);
        $output->writeln("Password for user: ".$defaultPassword);
        return true;
    }

    /**
     * @return EntityManager
     */
    protected function getDoctrine()
    {
        return $this->getContainer()->get('doctrine.orm.default_entity_manager');
    }
}